/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.mapui;

import filenet.vw.toolkit.utils.mapui.VWBaseTextAnnotationUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;

final class VWDesignerDraggedAssociationUI
extends JComponent {
    private Point m_srcPt = null;
    private Point m_destPt = null;
    private VWBaseTextAnnotationUI m_srcTextAnnotation = null;

    public VWDesignerDraggedAssociationUI(VWBaseTextAnnotationUI srcTextAnnotation) {
        this.m_srcTextAnnotation = srcTextAnnotation;
        this.m_srcPt = this.m_srcTextAnnotation.getImageCenterLocation();
        this.m_destPt = new Point(this.m_srcPt);
        Rectangle rect = new Rectangle(this.m_srcPt.x, this.m_srcPt.y, 0, 0);
        rect.width = 0;
        rect.height = 0;
        this.setBounds(rect);
    }

    public void mouseDragged(Point loc) {
        this.m_destPt.x = loc.x;
        this.m_destPt.y = loc.y;
        Rectangle rect = this.getBounds();
        rect.x = this.m_srcPt.x <= loc.x ? this.m_srcPt.x - 1 : loc.x - 1;
        rect.y = this.m_srcPt.y <= loc.y ? this.m_srcPt.y - 1 : loc.y - 1;
        rect.width = Math.abs(loc.x - this.m_srcPt.x) + 2;
        rect.height = Math.abs(loc.y - this.m_srcPt.y) + 2;
        this.setBounds(rect);
    }

    public void paintComponent(Graphics g) {
        Point startPoint = this.getStartPoint();
        Color curColor = g.getColor();
        g.setColor(Color.black);
        g.drawLine(startPoint.x, startPoint.y, this.m_destPt.x, this.m_destPt.y);
        g.setColor(curColor);
        this.m_srcTextAnnotation.paintComponent(g);
    }

    public VWBaseTextAnnotationUI getSourceTextAnnotation() {
        return this.m_srcTextAnnotation;
    }

    public Point getStartPoint() {
        double angle;
        double horz = this.m_destPt.x - this.m_srcPt.x;
        double vert = this.m_destPt.y - this.m_srcPt.y;
        if (horz != 0.0) {
            angle = Math.atan(vert / horz);
            if (horz < 0.0) {
                angle = vert > 0.0 ? Math.PI + angle : -Math.PI + angle;
            }
        } else {
            angle = vert > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        return this.m_srcTextAnnotation.getBoundaryPoint(angle);
    }
}

